<?php

namespace Good\Morning\Controller\Adminhtml\Index;

use Good\Morning\Model\HelloWorldFactory;
use Good\Morning\Model\ImageUploader;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Cache\Manager as CacheManager;
use Magento\Framework\Data\Form\FormKey\Validator;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\Redirect;


class Save extends Action
{
    
    protected $resultPageFactory;

    
    protected $helloWorldFactory;

    protected $formKeyValidator;

    
    protected $imageUploader;

    
    protected $messageManager;

    
    protected $cacheManager;

    
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        HelloWorldFactory $helloWorldFactory,
        Validator $formKeyValidator,
        ImageUploader $imageUploader,
        ManagerInterface $messageManager,
        CacheManager $cacheManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->helloWorldFactory = $helloWorldFactory;
        $this->formKeyValidator = $formKeyValidator;
        $this->imageUploader = $imageUploader;
        $this->messageManager = $messageManager;
        $this->cacheManager = $cacheManager;
        parent::__construct($context);
    }

    
    public function execute()
    {
        
        $resultRedirect = $this->resultRedirectFactory->create();

        if (!$this->formKeyValidator->validate($this->getRequest())) {
            $this->messageManager->addErrorMessage(__('Form key is invalid.'));
            return $resultRedirect->setPath('*/*/index');
        }

        $data = $this->getRequest()->getPostValue();
        if ($data) {
            try {
                $model = $this->helloWorldFactory->create();
                $model->setData($data);
                $model = $this->processImageData($model, $data);
                $model->save();

                $this->messageManager->addSuccessMessage(__('Data saved successfully.'));

                $buttonData = $this->getRequest()->getParam('back');
                if ($buttonData == 'add') {
                    return $resultRedirect->setPath('*/*/form');
                }
                if ($buttonData == 'close') {
                    return $resultRedirect->setPath('*/*/index');
                }
                return $resultRedirect->setPath('*/*/form', ['id' => $model->getId()]);
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(__('We can\'t submit your request. Please try again.'));
            }
        }
        return $resultRedirect->setPath('*/*/index');
    }

    
    protected function processImageData($model, $data)
    {
        if (isset($data['image_field'][0]['name'])) {
            $imageName = $data['image_field'][0]['name'];
            $imageUrl = $data['image_field'][0]['url'];

            if ($model->getId()) {
                $existingModel = $this->helloWorldFactory->create()->load($model->getId());
                $existingImage = $existingModel->getThumbnail();

                if ($existingImage != $imageName) {
                    $data['image_field'] = $this->imageUploader->saveMediaImage($imageName, $imageUrl);
                } else {
                    $data['image_field'] = $imageName;
                }
            } else {
                $data['image_field'] = $this->imageUploader->saveMediaImage($imageName, $imageUrl);
            }
        } else {
            $data['image_field'] = '';
        }

        $model->setData($data);
        return $model;
    }
}
