<?php

namespace Good\Morning\Setup\Patch\Data;

use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Module\Setup\Migration;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class AddData implements DataPatchInterface
{
     private $HelloWorldFactory;

     public function __construct(
          \Good\Morning\Model\HelloWorldFactory $HelloWorldFactory
     ) {
          $this->HelloWorldFactory = $HelloWorldFactory;
     }

     public function apply()
     {
          $sampleData = [
               [
                    'status' => 1, 
                    'first_name' => 'Sample Text 1 for Data 1', 
                    'last_name' => 'Sample Text 2 for Data 1',
                    'image_field' => ''
               ],
               [
                    'status' => 1, 
                    'first_name' => 'Sample Text 1 for Data 2', 
                    'last_name' => 'Sample Text 2 for Data 2',
                    'image_field' => ''
               ]
          ];
          foreach ($sampleData as $data) {
               $this->HelloWorldFactory->create()->setData($data)->save();
          }
     }

     public static function getDependencies()
     {
          return [];
     }

     public function getAliases()
     {
          return [];
     }
     
}